/*
Copyright (C) 2004-2010  Andy Mutton

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

Contact: andy@5263.org
*/
screengrab.prefs = {
	
	PNG  : "png",
	JPEG : "jpeg",
	JPG  : "jpg",

	extensionPrefix : "extensions.screengrab.",

	prefPrependDateStampInFilename  : "PrependDateStampInFilename",
	prefPrependTimeStampInFilename  : "PrependTimeStampInFilename",
	prefAppendDecUTCStampInFilename : "AppendDecUTCStampInFilename",
	prefAppendHexUTCStampInFilename : "AppendHexUTCStampInFilename",

	prefImageFormat  : "ImageFormat",
	prefImageQuality : "ImageQuality",

	prefShowIconInStatusBar   : "ShowIconInStatusBar",
	prefShowInContextMenu     : "ShowInContextMenu",
	prefShowFileInDownloads   : "ShowFileInDownloads",
	prefUseBrowserDownloadDir : "UseBrowserDownloadDir",
	prefToolbarAddedOnce      : "ToolbarAddedOnce",
	prefUseJavaIfAvailable    : "UseJavaIfAvailable",
	prefJavaScrollWaitMs      : "JavaScrollWaitMs",

	prefEnableLogging  : "EnableLogging",
	prefLoggerFilename : "LoggerFilename",

	prefNumberofGrabsTaken : "NumberofGrabsTaken",
	prefMagic              : "Magic",
	
	prefBranch : null,
	
	getBool: function(pref, defValue) {
		return nsPreferences.getBoolPref(this.extensionPrefix + pref, defValue);
	},
	
	getInt: function(pref, defValue) {
	        return nsPreferences.getIntPref(this.extensionPrefix + pref, defValue);
	},

	getString: function(pref, defValue) {
	        return nsPreferences.copyUnicharPref(this.extensionPrefix + pref, defValue);
	},
	
	format : function() {
		if (this.getInt(this.prefImageFormat, 2) == 0) {
		    return this.PNG;
		} else if (this.getInt(this.prefImageFormat, 2) == 1) {
		    return this.JPEG;
		} else {
		    return this.JPG;
		}
    	},
	
	formatMimeType : function() {
		if (this.getInt(this.prefImageFormat, 2) == 0) {
		    return "image/png";
		} else {
		    return "image/jpeg";
		}
    	},
	
	formatQuality : function(mimeType) {
		if (mimeType == "image/png") {
			return 1.0; // technically not supposed to return anything but I think this is safest
		}
		//SDM https://developer.mozilla.org/en-US/docs/DOM/HTMLCanvasElement
		//should be 0.0 to 1.0
		// since the prefs are normal 0-100, I will just divide by 100
		// not sure what the quality= parameter used to be passed to but it didn't work!
		//return 'quality=' + this.getInt(this.prefImageQuality, 75);
		return this.getInt(this.prefImageQuality, 75) / 100.0;
    	},
	
	showFileInDownloads : function() {
		return this.getBool(this.prefShowFileInDownloads, false);
	},
    
	defaultFileName : function() {
		var filename1 = window.content.document.title;
		//var filename1 = new String("bbbb/bbb\bbD]e[t,a?i*l)o(r:a\a/a>a<a;a - Pro\gram Detail Files for MyTheatre");
		var filename2 = new String(screengrab.File.sanitizeName(filename1));
		var filename = filename2.trim();

		var dt = new Date();


		if (this.getBool(this.prefPrependDateStampInFilename) || this.getBool(this.prefPrependTimeStampInFilename) ) {

			var yr = dt.getFullYear();

			var mo = 1 + dt.getMonth();
			mo = mo < 10 ? "0" + mo : mo;

			var da = dt.getDate();
			da = da < 10 ? "0" + da : da;

			var hr = dt.getHours();
			hr = hr < 10 ? "0" + hr : hr;

			var mi = dt.getMinutes();
			mi = mi < 10 ? "0" + mi : mi;


			var ds = String(yr) + String(mo) + String(da);
			var ts = String(hr) + String(mi);

			if (this.getBool(this.prefPrependTimeStampInFilename) && this.getBool(this.prefPrependDateStampInFilename)) {
				filename = String(ds) + "-" + String(ts) + "_" + filename;
			}
			else if (this.getBool(this.prefPrependTimeStampInFilename)) {
				filename = String(ts) + "_" + filename;
			}
			else {
				filename = String(ds) + "_" + filename;
			}
		}
	        
		if (this.getBool(this.prefAppendDecUTCStampInFilename)) {
			filename = filename + "_" + dt.getTime();
		}

		//SDM if some goof enables both, I want HEX appended last
		if (this.getBool(this.prefAppendHexUTCStampInFilename)) {
			var i = dt.getTime() / 1000;
			var ni = new Number(i);
			var fni = new Number(ni.toFixed(0));
			var sfni = new String(fni.toString(16));

			//SDM 0x unneeded
			//filename = filename + "_0x" + sfni.toUpperCase();

			filename = filename + "_" + sfni.toUpperCase();
		}

		return filename;
	},
	
	loggerFileName : function() {
//		if (window.navigator.userAgent.toLowerCase().indexOf("win") > -1) {
//			var defaultFileName = "C:\screengrab.log";
//		} else {
//			var defaultFileName = "/tmp/screengrab.log";
//		}
//		return this.getString(this.prefLoggerFilename, defaultFileName);
		
		//SDM slightly hidden feature. log if log name is set AND loggging is on (so you can console log without file log)
		return this.getString(this.prefLoggerFilename);
	},
	
	loggingEnabled : function() {
		return this.getBool(this.prefEnableLogging, false);
	},
	
	/*
	 * The time to wait for Java applets to get ready after scrolling 
	 * them into position to capture them.
	 */
	javaScrollWaitTime : function() {
		var defaultTime = 100;
		if (window.navigator.userAgent.toLowerCase().indexOf("mac") > -1) {
			defaultTime = 400;
		}
		return this.getInt("prefJavaScrollWaitMs", defaultTime);
	},
	
	javaEnabled : function() {
		if (!window.navigator.javaEnabled()) {
			return false;
		}
		return this.getBool("prefUseJavaIfAvailable", false);
	},
	
	incGrabCount : function() {
		var numTaken = this.getInt(this.prefNumberofGrabsTaken, 0);
		nsPreferences.setIntPref(this.extensionPrefix + this.prefNumberofGrabsTaken, numTaken + 1);
	},
	
	browserDownloadDir : function() {
		return nsPreferences.copyUnicharPref("browser.download.dir");
	},
	
	useBrowserDownloadDir : function () {
		return this.getBool(this.prefUseBrowserDownloadDir);
	},
	
	toolbarAddedOnce: function() {
		return this.getBool(this.prefToolbarAddedOnce);
	},
	
	setToolbarAddedOnce: function() {
        	return nsPreferences.setBoolPref(this.extensionPrefix + this.prefToolbarAddedOnce, true);
    	},
	
	refreshStatusbar : function() {

		sg.debug("refreshStatusbar " + this.getBool(this.prefShowIconInStatusBar) );
		
		if (this.getBool(this.prefShowIconInStatusBar, true)) {
			this.show("screengrab_panel");
		} else {
			this.hide("screengrab_panel");
		}
	},
	

	refreshContextMenu : function() {
		if (this.getBool(this.prefShowInContextMenu, true)) {
			this.show("screengrab-context-menu");
			this.show("screengrab-context-separator");
		} else {
			this.hide("screengrab-context-menu");
			this.hide("screengrab-context-separator");
		}
	},
	
//SDM Alexander seems to have stripped this out for whatever reason (maybe that java couldn't be used?)

	refreshMenuChoices : function() {
		if (!this.javaEnabled()) {
			this.hide("pop-grabWindow");
			this.hide("pop-copyWindow");
		} else {
			this.show("pop-grabWindow");
			this.show("pop-copyWindow");
		}
	},

	refreshShortcuts : function() {
//	  setShortcut("screengrab-key-copy-complete", "c", "control shift");
//        setShortcut("screengrab-key-copy-visible", "v", "control shift");
//        setShortcut("screengrab-key-save-complete", "d", "control shift");
//        setShortcut("screengrab-key-save-visible", "f", "control shift");
    },
	
	setShortcut : function(id, key, modifiers) {
		var keyElem = document.getElementById(id);
		keyElem.key = key;
		keyElem.modifiers = modifiers;
	},
	
	observe : function(aSubject, aTopic, aData) {
		if (aTopic != "nsPref:changed") return;
		
		sg.debug("Observed change in " + aData);
		
	    	switch (aData) {
	    	
	    	case this.prefShowIconInStatusBar: 
			this.refreshStatusbar();
	        	break;
	        	
	    	case this.prefShowInContextMenu:
			this.refreshContextMenu();
	        	break;
	    	}
		refreshShortcuts();
	},
	
	register: function() {
		var prefService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService);
		this.prefBranch = prefService.getBranch(this.extensionPrefix);
		this.prefBranch.QueryInterface(Components.interfaces.nsIPrefBranch2);
		this.prefBranch.addObserver("", this, false);
	},
	
	unregister: function() {
		if (!this.prefBranch) return;
		this.prefBranch.removeObserver("", this);
    	},
	
	hide : function(elementId) {
		try {
			document.getElementById(elementId).style.display = "none";
		} catch (error) {
			sg.error(error + ":" + elementId);
		}
	},
	
	show : function(elementId) {
		try {
			document.getElementById(elementId).style.display = "";
		} catch (error) {
			sg.error(error + ":" + elementId);
		}
	},
	
	configuratePrefs : function() {
		screengrab.prefs.register();
		//SDM here's a virgin setTimeout defining a function inline, like Alexander added in other places.
		setTimeout(function() {
			screengrab.prefs.refreshContextMenu();
			screengrab.prefs.refreshStatusbar();
			screengrab.prefs.refreshMenuChoices();
            		screengrab.prefs.refreshShortcuts();
		}, 100);
	},
	
	instantApply: function() {
		return nsPreferences.getBoolPref("browser.preferences.instantApply");
	},
	
	openPrefs:function() {
		window.openDialog("chrome://screengrab/content/preferences.xul", "screengrab-options-dialog", "toolbar,centerscreen,chrome,modal,resizable" + this.instantApply() ? ",dialog=no" : "");
	}
}

window.addEventListener("load", function() {
    	screengrab.prefs.configuratePrefs();
}, false);
