
screengrab.EmbeddedCapture = function(htmlDoc, captureBox, context) {
	this.context = context;
	this.captureBox = captureBox;
	// only get the embeds that are in the area to capture

//	var toCopy = htmlDoc.getAllEmbeddedDimensions()
//                   .filter(function(element) {
//				   	   return element.intersects(captureBox)
//					});

//SDM Alexander's code splits this up nicer but would otherwise seem to do the same thing

	var boxesToGrab = htmlDoc.getAllEmbeddedDimensions();

	var toCopy = boxesToGrab.filter(function(element) { return element.intersects(captureBox) } );

	
	var regions = new Array();
	var viewportDimensions = screengrab.Browser.viewportAbsoluteDimensions();
	toCopy.forEach(function(element) {
		// only want to capture the bit that's in the target area
		var intersection = element.intersection(captureBox);
		
		// split the embeds so that they will fit into the window
		var split = intersection.toBoxesSmallerThan(viewportDimensions.width, viewportDimensions.height);
		sg.debug("Split... " + split);
        regions = regions.concat(split);
    });
	this.regions = regions;
}
screengrab.EmbeddedCapture.prototype = {
	capture: function(onFinish, htmlWindow) {
		if (this.regions.length == 0 || !screengrab.Java.isAvailable()) {
			onFinish();
			return;
		}
		var viewportDimensions = screengrab.Browser.viewportAbsoluteDimensions();
		var context = this.context;
		var regions = this.regions;
        var img = new Image();
		var box = new sg.Box(0, 0);
		var win = htmlWindow.htmlWin;
		var origScrollX = win.scrollX;
		var origScrollY = win.scrollY;
		var captureBox = this.captureBox;
		
		var nextImage = function() {
			sg.debug("Number of regions to grab " + regions.length);
            var element = regions.pop();
			box.x = element.x;
			box.y = element.y;
			box.width = element.width;
			box.height = element.height;
			var visibleRegion = new screengrab.Box(win.scrollX, win.scrollY, viewportDimensions.width, viewportDimensions.height);
			sg.debug("Visible " + visibleRegion + " To capture " + element);
			var doJavaCopy = function() {
	            var copy = element.offsetCopy(viewportDimensions.x - win.scrollX, viewportDimensions.y - win.scrollY);
	            var dataUrl = screengrab.Java.capture(copy);
	            sg.debug("Setting url");
	            img.src = dataUrl;
			}
			
			if (!visibleRegion.contains(box)) {
	            // scroll to region, snap it and save it
				sg.debug("Scrolling to [" + box.x + "," + box.y + "]");
				win.scrollTo(box.x, box.y);
				//setTimeout(doJavaCopy, sg.prefs.javaScrollWaitTime());
				//SDM more of Alexander defining a function. Still don't get it
				setTimeout(function() { doJavaCopy(); }, sg.prefs.javaScrollWaitTime());

			} else {
				// slight delay to allow everything to get into place
				//setTimeout(doJavaCopy, 10);
				//SDM more of Alexander defining a function. Still don't get it
				setTimeout(function() { doJavaCopy(); }, 10);
			}
        }
		
		img.onload = function() {
            sg.debug("onLoad hit");
            context.save();
            context.drawImage(img, box.x - captureBox.x, box.y - captureBox.y);
            context.save();
            if (regions.length != 0) {
                sg.debug("Next");
                nextImage();
            } else {
				sg.debug("Finishing");
                win.scrollTo(origScrollX, origScrollY);
                onFinish();
            }
		}
		nextImage();
	}
}